addpath('../3dParty/mtimesx/');

clear

useCA_CCRF = false;

% Check if parallel toolbox is present, and if GPU is supported, if so use
% it
useGPU = false;

v = ver;
if(any(strcmp('Parallel Computing Toolbox', {v.Name})))
    % need a GPU test here
    try
        g = gpuDevice;
        if(gpuDevice.DeviceSupported)
            useGPU = true;
        else
           fprintf('Gpu device not supported will not use gpu acceleration\n'); 
        end
    catch err
        fprintf('Cannot locate a gpu device will not use gpu acceleration\n');
    end
end

% set up the lambda ranges to check
lambdas_a_range = 0:2:10;
lambdas_b_range = 0:2:10;

lambdas_a = 10.^(lambdas_a_range);
lambdas_b = 10.^(lambdas_b_range);

for dim=1:4
   for fold=1:10
      crossvalidate_ca_ccrf_lambdas_bfgs(dim, lambdas_a, lambdas_b, fold, useCA_CCRF, useGPU);
   end
end
%%
[lambda_a, lambda_b] = getRegularisationResults('CCRF_BFGS');

%% 
evaluate_CCRF_bfgs(lambda_a, lambda_b, useCA_CCRF, 'CCRF_BFGS_res.mat');